﻿<%@ Page Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="MedRedTwoMinuteWalk.aspx.cs"
    Inherits="TBI_Instruments_MedRedTwoMinuteWalk" Title="" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>

<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>

        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

            var _inactiveTimePeriod = <%=ConfigurationManager.AppSettings["AutoSaveInactiveInSeconds"] %>; // in seconds, set in web.config

            attachEvent(window, 'load', function () {
                var _inactivetimer = $find("<%=InactiveTimer.ClientID %>");
                var idleSeconds = _inactiveTimePeriod;
                var idleTimer;
                function resetTimer() {
                     _inactivetimer._stopTimer();
                     _inactivetimer.set_interval(idleSeconds*1000);
                     _inactivetimer._startTimer();
                     
                }
                attachEvent(document.body, 'mousemove', resetTimer);
                attachEvent(document.body, 'keydown', resetTimer);
                attachEvent(document.body, 'click', resetTimer);

                resetTimer(); // Start the timer when the page loads
            });

            function attachEvent(obj, evt, fnc, useCapture) {
                if (obj.addEventListener) {
                    obj.addEventListener(evt, fnc, !!useCapture);
                    return true;
                }
                else if (obj.attachEvent) {
                    return obj.attachEvent("on" + evt, fnc);
                }
            }

            function clearRadioButtonListSelection(listName) 
            {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");

                var currIndex = GetListIndexSelected(listName);
                if (currIndex > -1) {
                    radio[currIndex].checked = false;
                }
            }

            function GetListIndexSelected(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                for (var i = 0; i < radio.length; i++) {
                    if (radio[i].checked) {
                        ret = i;
                        break;
                    }
                }

                return ret;

            } 

            function GetLastElementIndex(listName) {
                var rbList = document.getElementById(listName);
                var radio = rbList.getElementsByTagName("input");
                var ret = -1;

                ret = radio.length - 1;

                return ret;
            }

            function btnSaveButtonChange_Click() {
                //Save draft if question 8,15,16V,28 is changed occurs
                //document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                //alert("Auto-Saving");
            }

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > 2 Minute Walk Test"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="MRTMW" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="5" />
                    <br />
                </asp:Panel>
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <!-- Instruction Area -->
                    <br />
                    <table style="width: 100%; border: 1px solid navy;">
                        <tr>
                            <td>
                                <h2>
                                    2 Minute Walk Test Instructions</h2>
                                <br />
                                <h4>
                                    General Information:</h4>
                                <ul>
                                    <li>individual walks without assistance for 2 minutes and the distance is measured</li>
                                    <ul>
                                        <li>start timing when the individual is instructed to "Go"</li>
                                        <li>stop timing at 2 minutes</li>
                                        <li>assistive devices can be used but should be kept consistent and documented from test to test</li>
                                        <li>if physical assistance is required to walk, this should not be performed</li>
                                        <li>a measuring wheel is helpful to determine distance walked </li>
                                    </ul>
                                    <li>should be performed at the fastest speed possible</li>
                                </ul>
                                <h4>
                                    Set-up and equipment:</h4>
                                <ul>
                                    <li>ensure the hallway free of obstacles</li>
                                    <li>stopwatch</li>
                                </ul>
                                <h4>
                                    Patient Instructions:</h4>
                                <ul>
                                    <li>"Cover as much ground as possible over 2 minutes. Walk continuously if possible, but do not be concerned if you need to
                                        slow down or stop to rest. The goal is to feel at the end of the test that more ground could not have been covered in the
                                        2 minutes."</li>
                                </ul>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <!-- Question Area -->
                    <br />
                    <!-- Store Name -->
                    <asp:HiddenField ID="HiddenFieldName" runat="server" />
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td colspan="2">
                                <h2>
                                    2 Minute Walk Test</h2>
                                <br />
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <!--Assistive Device and/or Bracing Used-->
                                <asp:Label ID="LabelForDevice" runat="server" AssociatedControlID="txtDevice" SkinID="DataLabel">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td>
                                <!--Question 1 Answer -->
                                <asp:TextBox runat="server" ID="txtDevice" Width="320px" TabIndex="6"></asp:TextBox>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDevice" runat="server" ControlToValidate="txtDevice" TabIndex="7" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Enter the device bar code."></asp:RequiredFieldValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="10" />
                            </td>
                        </tr>
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    <br />
                    <table style="width: 800px; border: 1px solid navy;">
                        <tr>
                            <td colspan="6">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="width: 70px; text-align: right; font-weight: bolder;">
                                <!--Date 1-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="17">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td style="width: 5px;">
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <!--Date 1 picker-->
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="18">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 1 required field validator (only one required)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="19" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Date is required."></asp:RequiredFieldValidator>
                            </td>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Distance 1-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDistance1" runat="server" AssociatedControlID="txtDistance1" SkinID="DataLabel" TabIndex="20">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td style="width: 5px;">
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <asp:TextBox ID="txtDistance1" runat="server" Width="140px" TabIndex="21"></asp:TextBox>
                                meters
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDistance1" runat="server" ControlToValidate="txtDistance1" TabIndex="22"
                                    ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="Distance is required."></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorDistance1" runat="server" TabIndex="23" ControlToValidate="txtDistance1"
                                    ErrorMessage="Distance must be valid, postive whole number between (0-999)" MaximumValue="999" MinimumValue="0" SetFocusOnError="true"
                                    ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                </asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Date 2-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate2" runat="server" AssociatedControlID="dpDate2" SkinID="DataLabel" TabIndex="24">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <!--Date 2 picker-->
                                <telerik:RadDatePicker ID="dpDate2" runat="server" TabIndex="25">
                                    <Calendar ID="Calendar2" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 2 required field validator (only required if Distance 2 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate2" runat="server" ControlToValidate="dpDate2" TabIndex="26" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Date is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Distance 2-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDistance2" runat="server" AssociatedControlID="txtDistance2" SkinID="DataLabel" TabIndex="27">
                                </asp:Label> <span class="requiredField" title="Required Field">*</span>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <asp:TextBox ID="txtDistance2" runat="server" Width="140px" TabIndex="28"></asp:TextBox>
                                meters
                                <!--Distance 2 required field validator (only required if Date 2 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDistance2" runat="server" ControlToValidate="txtDistance2" TabIndex="29"
                                    ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="Distance is required." Enabled="false"></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorDistance2" runat="server" TabIndex="30" ControlToValidate="txtDistance2"
                                    ErrorMessage="Distance must be valid, postive whole number between (0-999)" MaximumValue="999" MinimumValue="0" SetFocusOnError="true"
                                    ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                </asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Date 3-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate3" runat="server" AssociatedControlID="dpDate3" SkinID="DataLabel" TabIndex="31">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <!--Date 3 picker-->
                                <telerik:RadDatePicker ID="dpDate3" runat="server" TabIndex="32">
                                    <Calendar ID="Calendar3" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 3 required field validator (only required if Distance 3 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate3" runat="server" ControlToValidate="dpDate3" TabIndex="33" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Date is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Distance 3-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDistance3" runat="server" AssociatedControlID="txtDistance3" SkinID="DataLabel" TabIndex="34">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <asp:TextBox ID="txtDistance3" runat="server" Width="140px" TabIndex="35"></asp:TextBox>
                                meters
                                <!--Distance 3 required field validator (only required if Date 3 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDistance3" runat="server" ControlToValidate="txtDistance3" TabIndex="36"
                                    ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="Distance is required." Enabled="false"></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorDistance3" runat="server" TabIndex="37" ControlToValidate="txtDistance3"
                                    ErrorMessage="Distance must be valid, postive whole number between (0-999)" MaximumValue="999" MinimumValue="0" SetFocusOnError="true"
                                    ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                </asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                &nbsp;
                            </td>
                        </tr>
                        <tr>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Date 4-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDate4" runat="server" AssociatedControlID="dpDate4" SkinID="DataLabel" TabIndex="38">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <!--Date 4 picker-->
                                <telerik:RadDatePicker ID="dpDate4" runat="server" TabIndex="39">
                                    <Calendar ID="Calendar4" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                <!--Date 4 required field validator (only required if Distance 4 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate4" runat="server" ControlToValidate="dpDate4" TabIndex="40" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="Date is required." Enabled="false"></asp:RequiredFieldValidator>
                            </td>
                            <td style="text-align: right; font-weight: bolder;">
                                <!--Distance 4-->
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelDistance4" runat="server" AssociatedControlID="txtDistance4" SkinID="DataLabel" TabIndex="41">
                                </asp:Label>
                            </td>
                            <td>
                                &nbsp;
                            </td>
                            <td style="text-align: left;">
                                <asp:TextBox ID="txtDistance4" runat="server" Width="140px" TabIndex="42"></asp:TextBox>
                                meters
                                <!--Distance 4 required field validator (only required if Date 4 is present)-->
                                <br />
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDistance4" runat="server" ControlToValidate="txtDistance4" TabIndex="43"
                                    ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="Distance is required." Enabled="false"></asp:RequiredFieldValidator>
                                <asp:RangeValidator ID="RangeValidatorDistance4" runat="server" TabIndex="44" ControlToValidate="txtDistance4"
                                    ErrorMessage="Distance must be valid, postive whole number between (0-999)" MaximumValue="999" MinimumValue="0" SetFocusOnError="true"
                                    ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                </asp:RangeValidator>
                            </td>
                        </tr>
                        <tr>
                            <td colspan="6">
                                &nbsp;
                            </td>
                        </tr>
                    </table>
                    <!-- Hidden Averages - Only if more than one trial was performed. -->
                    <asp:HiddenField ID="HiddenAverageTime" runat="server" />
                    <asp:HiddenField ID="HiddenAverageDistance" runat="server" />
                    <!-- End Question Area -->
                    <br />
                    <asp:Panel ID="pnlReferences" runat="server">
                        <span style="font-weight: bold; text-decoration: underline;">References:</span><br />
                        <p>
                            Butland RJ, Pang J, Gross ER, Woodcock AA, Geddes DM. Two-, six-, and 12-minute walking tests in respiratory disease. Br
                            Med J (Clin Res Ed). 1982 May 29;284(6329):1607-8.</p>
                        <p>
                            McGavin CR, Gupta SP, McHardy GJ. Twelve-minute walking test for assessing disability in chronic bronchitis. Br Med J. 1976;
                            3;1(6013):822-3.</p>
                        <p>
                            Rossier P, Wade DT. Validity and reliability comparison of 4 mobility measures in patients presenting with neurologic impairment.
                            Arch Phys Med Rehabil. 2001;82(1):9-13.</p>
                    </asp:Panel>
                </asp:Panel>
                <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                    <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                </telerik:RadAjaxPanel>
                <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                    ValidationGroup="OnSaveDraft" TabIndex="45" />
                <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                    ValidationGroup="OnSave" TabIndex="46" />
                <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="47" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>
